<?php
/**
 * This file stores all default settings.
 *
 * @category Framework
 * @package  OxyProps
 * @author   Cédric Bontems <cedric@thewebforge.dev>
 * @license  https://www.gnu.org/licenses/gpl-2.0.html  GPL v2 or later
 * @link     https://oxyprops.com                       OxyProps Website
 * @since    1.5.0
 */

namespace OxyProps\Inc;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Stores and returns plugin defaults
 *
 * @author   Cédric Bontems <cedric@thewebforge.dev>
 * @since    1.5.0
 */
final class Defaults_Normalize {

	/**
	 * Unique instance of Defaults_Normalize
	 *
	 * @author   Cédric Bontems <cedric@thewebforge.dev>
	 * @since    1.5.0
	 *
	 * @var object Self stored instance
	 */
	private static $instance = null;

	/**
	 * Returns the unique instance of Defaults_Normalize
	 * and creates one if it does not already exist.
	 *
	 * @author   Cédric Bontems <cedric@thewebforge.dev>
	 * @since    1.5.0
	 *
	 * @return object Defaults_Normalize singleton.
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new Defaults_Normalize();
		}
		return self::$instance;
	}

	/**
	 * Returns the OxyProps version of Oxygen Global Settings
	 *
	 * @author   Cédric Bontems <cedric@thewebforge.dev>
	 * @since    1.5.0
	 *
	 * @return array Gloabal settings for Oxygen.
	 */
	public function get_normalize_defaults() {
		$defaults = array();

		$defaults['html'] = array(
			'accent-color'             => array(
				'apply' => true,
				'value' => 'var(--o-brand)',
			),
			'caret-color'              => array(
				'apply' => true,
				'value' => 'var(--o-brand)',
			),
			'-webkit-text-size-adjust' => array(
				'apply' => true,
				'value' => 'none',
			),
			'background-color'         => array(
				'apply' => true,
				'value' => 'var(--o-surface-1)',
			),
			'block-size'               => array(
				'apply' => true,
				'value' => '100%',
			),
			'font-family'              => array(
				'apply' => true,
				'value' => 'var(--o-font-sans)',
			),
			'scrollbar-color'          => array(
				'apply' => true,
				'value' => 'var(--o-scrollbar-color) transparent',
			),
			'color-scheme'             => array(
				'apply' => true,
				'value' => 'light',
			),
		);
			return apply_filters( 'oxyprops_normalize_defaults', $defaults );
	}
}
